// lib/csr.ts
export async function getActiveCSR() {
  try {
    const res = await fetch(
      "https://app.pussalla.gallezone.site/api/v1/csr/active",
      {
        cache: "no-store", // always fetch fresh data
      }
    );

    if (!res.ok) {
      throw new Error("Failed to fetch CSR data");
    }

    const data = await res.json();
    return data; // adjust based on API response structure
  } catch (error) {
    console.error(error);
    return [];
  }
}
