"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import { motion, easeOut } from "framer-motion";
import "swiper/css";
import "swiper/css/pagination";
import "swiper/css/autoplay";
import "swiper/css/navigation";

export default function WhyUsMobileSlider() {
  const features = [
    {
      title: "Integrated Value Chain",
      description:
        "The key to our operational strength is the complete ownership and control of our supply chain.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <path d="M3 21h18M3 10l6 4V9l6 4V8l6 4v9" />
        </svg>
      ),
    },
    {
      title: "Reliable Supply and Capacity",
      description:
        "We continually scale our production and service capacities to cater the demands our customers without disappointment.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z" />
          <path d="m9 12 2 2 4-4" />
        </svg>
      ),
    },
    {
      title: "Uncompromising Quality",
      description:
        "All our standards of quality, hygiene and safety are best in the industry and consistent across all stages.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <path d="M21 16V8a2 2 0 0 0-1-1.73l-8-4.62a2 2 0 0 0-2 0l-8 4.62A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l8 4.62a2 2 0 0 0 2 0l8-4.62A2 2 0 0 0 21 16Z" />
          <path d="M3.3 7L12 12l8.7-5M12 22V12" />
        </svg>
      ),
    },
    {
      title: "Advanced Technology",
      description:
        "All our farms, hatcheries and processing plants are equipped with state-of-the-art technology supported by globally accepted processes and practices.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <path d="M10 17h4v-3H3v6h2a2 2 0 0 0 2-2v-1h3v-1zm11-4h-5v3h5l1.5 3H23v-4.5L21 13z" />
        </svg>
      ),
    },
    {
      title: "Traceability and Transparency",
      description:
        "Thanks to our vertically integrated value chain, everything we produce and provide can be transparently traceable.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <path d="M9 18h6M10 22h4m-2-4v2m-3-6a7 7 0 1 1 6 0c0 1.1-.9 2-2 2H9c-1.1 0-2-.9-2-2Z" />
        </svg>
      ),
    },
    {
      title: "Sustainable Practices",
      description:
        "Pussalla engages in Sustainable practices in both sourcing and production, while investing on farming community development as well as Animals welfare.",
      icon: (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="w-8 h-8"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          strokeWidth="2"
        >
          <circle cx="12" cy="8" r="6" />
          <path d="M8 21v-4l4-2 4 2v4" />
        </svg>
      ),
    },
  ];

  const cardVariant = {
    hidden: { opacity: 0, y: 50 },
    visible: {
      opacity: 1,
      y: 0,
      transition: { duration: 0.6, ease: easeOut },
    },
  };

  return (
    <div className="block md:hidden">
      <Swiper
        modules={[Navigation, Pagination, Autoplay]}
        navigation
        loop
        autoplay={{ delay: 3000, disableOnInteraction: false }}
        spaceBetween={20}
        slidesPerView={1}
        className="whyus-swiper"
      >
        {features.map((feature, index) => (
          <SwiperSlide key={index}>
            <motion.div
              className="bg-white p-8 rounded-[20px] md:rounded-[30px] shadow-lg text-center mx-4"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariant}
            >
              <div className="flex justify-center mb-4">
                <div className="bg-black text-white p-4 rounded-full">
                  {feature.icon}
                </div>
              </div>
              <h4 className="text-lg font-semibold">{feature.title}</h4>
              <p className="text-[#909090] text-sm mt-2">
                {feature.description}
              </p>
            </motion.div>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}
