"use client";

import Image from "next/image";
import { motion, easeOut } from "framer-motion";
import WhyUsSlider from "./WhyUsSlider";

export default function WhyUsSection() {
  const cardVariantLeft = {
    hidden: { opacity: 0, x: -50 },
    visible: {
      opacity: 1,
      x: 0,
      transition: { duration: 0.6, ease: easeOut },
    },
  };

  const cardVariantRight = {
    hidden: { opacity: 0, x: 50 },
    visible: { opacity: 1, x: 0, transition: { duration: 0.6, ease: easeOut } },
  };

  const cardVariantCenter = {
    hidden: { opacity: 0, y: 50 },
    visible: { opacity: 1, y: 0, transition: { duration: 0.6, ease: easeOut } },
  };

  return (
    <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-gradient-to-t from-[#EEEEEE] to-[#FFFFFF] overflow-hidden">
      <div className="container mx-auto px-4">
        {/* Heading */}
        <div className="flex flex-col md:flex-row md:items-center md:justify-center mb-10 md:mb-16 gap-6 text-center">
          <div className="text-center">
            <span className="sub-header">Why Choose Us</span>
            <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold leading-tight text-center">
              Setting new standards for Agri-Business
            </h2>
          </div>

          {/* Button beside title */}
          {/* <div className="hidden md:inline-block">
            <a
              href="/about"
              className="primary-btn whitespace-nowrap self-center md:self-auto"
            >
              Explore More
            </a>
          </div> */}
        </div>

        {/* Mobile Slider */}
        <WhyUsSlider />

        {/* Button below slider */}
        {/* <div className="flex justify-center md:hidden mt-5">
          <a
            href="/about"
            className="primary-btn whitespace-nowrap self-center md:self-auto"
          >
            Explore More
          </a>
        </div> */}

        {/* Content Grid */}
        <div className="hidden md:grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-10 items-center">
          {/* Left Features */}
          <div className="space-y-15">
            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantLeft}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/intergrated-value-chain.png"}
                    alt="Integrated Value Chain icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">Integrated Value Chain</h4>
              <p className="text-[#909090] text-sm mt-2">
                The key to our operational strength is the complete ownership
                and control of our supply chain.
              </p>
            </motion.div>

            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantLeft}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/uncompromising-quality.png"}
                    alt="Uncompromising Quality icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">Uncompromising Quality</h4>
              <p className="text-[#909090] text-sm mt-2">
                All our standards of quality, hygiene and safety are best in the
                industry and consistent across all stages.
              </p>
            </motion.div>

            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantLeft}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/sustainable-practices.png"}
                    alt="Sustainable Practices icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">Sustainable Practices</h4>
              <p className="text-[#909090] text-sm mt-2">
                Pussalla engages in Sustainable practices in both sourcing and
                production, while investing on farming community development as
                well as Animals welfare.
              </p>
            </motion.div>
          </div>

          {/* Center Image */}
          <motion.div
            className="flex justify-center rounded-[30px] shadow-lg order-last lg:order-none h-full"
            initial="hidden"
            whileInView="visible"
            viewport={{ once: true, amount: 0.3 }}
            variants={cardVariantCenter}
          >
            <Image
              src="/images/whyus/why-choose-us.webp"
              alt="Team"
              className="rounded-[30px] shadow-lg w-full object-cover md:hidden lg:block"
              width={600}
              height={600}
            />
          </motion.div>

          {/* Right Features */}
          <div className="space-y-15">
            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantRight}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/reliable-supply-capacity.png"}
                    alt="Reliable Supply and Capacity icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">
                Reliable Supply and Capacity
              </h4>
              <p className="text-[#909090] text-sm mt-2">
                We continually scale our production and service capacities to
                cater the demands our customers without disappointment.
              </p>
            </motion.div>

            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantRight}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/advanced-technology.png"}
                    alt="Advanced Technology icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">Advanced Technology</h4>
              <p className="text-[#909090] text-sm mt-2">
                All our farms, hatcheries and processing plants are equipped
                with state-of-the-art technology supported by globally accepted
                processes and practices.
              </p>
            </motion.div>

            <motion.div
              className="bg-white p-6 rounded-[30px] shadow-lg text-center transform-gpu"
              initial="hidden"
              whileInView="visible"
              viewport={{ once: true, amount: 0.3 }}
              variants={cardVariantRight}
            >
              <div className="flex justify-center -mt-15 mb-4">
                <div className="bg-black text-white p-5 rounded-full">
                  <Image
                    width={40}
                    height={40}
                    src={"/images/whyus/traceability-transparency.png"}
                    alt="Traceability and Transparency icon"
                  />
                </div>
              </div>
              <h4 className="text-lg font-semibold">
                Traceability and Transparency
              </h4>
              <p className="text-[#909090] text-sm mt-2">
                Thanks to our vertically integrated value chain, everything we
                produce and provide can be transparently traceable.
              </p>
            </motion.div>
          </div>
        </div>
      </div>
    </section>
  );
}
