"use client";

// import { Swiper, SwiperSlide } from "swiper/react";
// import { Navigation, Pagination, Autoplay } from "swiper/modules";
// import Image from "next/image";
import { motion, easeOut } from "framer-motion";

// import "swiper/css";
// import "swiper/css/navigation";
// import "swiper/css/pagination";

// const sustainabilities = [
//   {
//     img: "/images/sustainabilities/sustainability-01.png",
//     title: "Hatchery & Breeding Services",
//     description:
//       "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
//   },
//   {
//     img: "/images/sustainabilities/sustainability-02.png",
//     title: "Integrated Meat Production",
//     description:
//       "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam",
//   },
// ];

export default function SustainabilitySection() {
  const cardVariant = {
    hidden: { opacity: 0, y: 50 },
    visible: {
      opacity: 1,
      y: 0,
      transition: { duration: 0.6, ease: easeOut },
    },
  };
  return (
    // <section className="py-[130px] rounded-t-[100px] bg-linear-to-t from-[#FFFFFF] to-[#EEEEEE]">
    //   <div className="container mx-auto px-4">
    //     {/* Header Row with label, title, and button */}
    //     <div className="flex flex-col md:flex-row md:items-center md:justify-between mb-15 gap-4">
    //       <div>
    //         <span className="sub-header">Sustainability</span>
    //         <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mt-2">
    //           Sustainability at the Core<br></br>
    //           of Our Business
    //         </h2>
    //       </div>

    //       {/* Button beside title */}
    //       <a href="/sustainability" className="primary-btn whitespace-nowrap">
    //         Learn More
    //       </a>
    //     </div>

    //     {/* Slider */}
    //     <Swiper
    //       modules={[Navigation, Pagination, Autoplay]}
    //       navigation
    //       pagination={{ clickable: true }}
    //       loop={true}
    //       autoplay={{
    //         delay: 3000,
    //         disableOnInteraction: false,
    //       }}
    //       spaceBetween={20}
    //       slidesPerView={1}
    //       breakpoints={{
    //         640: { slidesPerView: 1 },
    //         768: { slidesPerView: 2 },
    //         1024: { slidesPerView: 2 },
    //       }}
    //     >
    //       {sustainabilities.map((sustainability, i) => (
    //         <SwiperSlide key={i}>
    //           <a href="/sustainability">
    //             <div className="rounded-[30px] overflow-hidden relative shadow-lg group">
    //               <Image
    //                 src={sustainability.img}
    //                 alt={sustainability.title}
    //                 className="w-full h-full object-cover transition-transform duration-500 ease-in-out group-hover:scale-110"
    //                 width={600}
    //                 height={400}
    //               />
    //               <div className="absolute inset-0 rounded-[30px] bg-gradient-to-t from-black/80 via-black/40 to-transparent transition-all duration-500 group-hover:from-black/0 group-hover:via-black/0"></div>

    //               <div className="absolute bg-black/50 border bottom-8 left-8 right-9 px-8 py-9 rounded-[15px] text-white items-center transition-transform duration-500 ease-in-out group-hover:translate-y-[-5px]">
    //                 <div className="text-left font-semibold text-white text-4xl sm:text-6xl lg:text-7xl xl:text-2xl mb-2">
    //                   <h4>{sustainability.title}</h4>
    //                 </div>
    //                 <p className="text-md text-left text-white font-cabin leading-relaxed">
    //                   {sustainability.description}
    //                 </p>
    //               </div>
    //             </div>
    //           </a>
    //         </SwiperSlide>
    //       ))}
    //     </Swiper>
    //   </div>
    // </section>

    <section className="py-[80px] sm:py-[100px] lg:py-[130px] rounded-t-[50px] lg:rounded-t-[100px] bg-gradient-to-t from-[#FFFFFF] to-[#EEEEEE]">
      <div className="container mx-auto px-4">
        {/* Header Row */}
        <motion.div
          initial="hidden"
          whileInView="visible"
          viewport={{ once: true, amount: 0.3 }}
          variants={{
            hidden: { opacity: 0, y: 50 },
            visible: {
              opacity: 1,
              y: 0,
              transition: { duration: 0.6, ease: "easeOut" },
            },
          }}
          className="flex flex-col md:flex-row items-center justify-center md:justify-between mb-10 lg:mb-15 gap-4"
        >
          <div className="flex-1 text-center md:text-left">
            <span className="sub-header">Sustainability and CSR</span>
            <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold text-center md:text-left">
              Preserved Ecologies, Empowered Communities
            </h2>
          </div>

          {/* Button beside title */}
          <div className="flex-1 text-right">
            <a href="/sustainability" className="primary-btn whitespace-nowrap">
              Learn More
            </a>
          </div>
        </motion.div>

        {/* Two Static Divs */}
        <div className="grid lg:grid-cols-2 gap-5 md:gap-10">
          {/* First Card */}
          <motion.a
            href="/sustainability"
            initial="hidden"
            whileInView="visible"
            viewport={{ once: true, amount: 0.3 }}
            variants={cardVariant}
            transition={{ delay: 0.1 }}
          >
            <div className="flex flex-col md:flex-row items-center justify-end md:justify-start md:items-end rounded-[30px] overflow-hidden relative shadow-lg group bg-[url(/images/sustainabilities/waste-management.webp)] p-5 md:p-9 bg-cover bg-right md:bg-top h-[450px] md:h-[400px]">
              <div className="w-[100%] md:w-[50%] p-5 md:p-9 border rounded-[15px] bg-black/50 text-white">
                <h4 className="text-2xl sm:text-4xl lg:text-5xl font-semibold mb-2">
                  Waste Management
                </h4>
                <p className="text-md leading-relaxed font-cabin">
                  Nothing should end up as waste, and anything that does should
                  end up in something useful. Driven by this doctrine,
                  Pussalla...
                </p>
              </div>
            </div>
          </motion.a>

          {/* Second Card */}
          <motion.a
            href="/sustainability"
            initial="hidden"
            whileInView="visible"
            viewport={{ once: true, amount: 0.3 }}
            variants={cardVariant}
            transition={{ delay: 0.3 }}
          >
            <div className="flex flex-col md:flex-row items-center justify-end md:justify-start md:items-end rounded-[30px] overflow-hidden relative shadow-lg group bg-[url(/images/sustainabilities/sustainability-02.png)] p-5 md:p-9 bg-cover bg-right md:bg-top h-[450px] md:h-[400px]">
              <div className="w-[100%] md:w-[50%] p-5 md:p-9 border rounded-[15px] bg-black/50 text-white">
                <h4 className="text-2xl sm:text-4xl lg:text-5xl font-semibold mb-2">
                  Environmental Preservation
                </h4>
                <p className="text-md leading-relaxed font-cabin">
                  Pussalla strongly believes in growing with utmost respect for
                  the environment, as ultimately we are all a part of it. In...
                </p>
              </div>
            </div>
          </motion.a>
        </div>
      </div>
    </section>
  );
}
