"use client";

import { motion, Variants, Transition } from "framer-motion";
import { FiEye } from "react-icons/fi";
import { LuGem } from "react-icons/lu";
import { TbTargetArrow } from "react-icons/tb";

export default function OverviewSection() {
  const cardVariants: Variants = {
    hidden: { opacity: 0, y: 60 },
    visible: (i: number) => ({
      opacity: 1,
      y: 0,
      transition: {
        duration: 0.7,
        delay: i * 0.2,
        ease: "easeOut" as Transition["ease"], // typed properly
      },
    }),
  };

  return (
    <>
      {/* Overview Text Section */}
      <section className="py-[80px] sm:py-[100px] lg:py-[130px] bg-white">
        <div className="container mx-auto px-4 text-center">
          <motion.span
            className="sub-header block"
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6, ease: "easeOut" }}
            viewport={{ once: true, amount: 0.3 }}
          >
            Overview
          </motion.span>

          <motion.h2
            className="text-3xl sm:text-4xl md:text-5xl lg:text-7xl xl:text-6xl font-bold mb-8 leading-tight max-w-5xl mx-auto px-2 sm:px-6 md:px-10 font-philosopher"
            initial={{ opacity: 0, y: 40 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8, ease: "easeOut", delay: 0.1 }}
            viewport={{ once: true, amount: 0.3 }}
          >
            Trusted Legacy from Farm-to-Fork
          </motion.h2>

          <motion.p
            className="text-[#909090] leading-relaxed font-cabin text-sm sm:text-base md:text-lg max-w-3xl mx-auto px-2 sm:px-6 md:px-10"
            initial={{ opacity: 0, y: 40 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8, ease: "easeOut", delay: 0.2 }}
            viewport={{ once: true, amount: 0.3 }}
          >
            Pussalla Meat Producers (Pvt) Ltd is story of humble beginnings that
            evolved into an end-to-end brand in Poultry and Agri-Business. Our
            fully integrated value-chain enriches an uncompromised standard of
            quality, hygiene and traceability from farm-to-fork. Driven by our
            mission, this is a promised that we have honoured, creating a legacy
            trust just among our consumers, but also among our local and
            international partners.
          </motion.p>
        </div>
      </section>

      {/* Vision, Mission, Values Section */}
      <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-white">
        <div className="container mx-auto px-4">
          <div className="flex flex-col lg:flex-row flex-wrap gap-10">
            {[
              {
                title: "Vision",
                icon: FiEye,
                text: `To be the leader in the processed food industry, by making a firm commitment to provide wholesome and safe products through conducting environmentally friendly operations and exercising complete control over the entire food supply chain from Farm to Fork.`,
              },
              {
                title: "Mission",
                icon: TbTargetArrow,
                text: `To take the lead in the food supply industry by understanding the multiple needs and wants of the customers in a rapidly changing environment, through committed adherence to responsible business practices and customer service, and through the delivery of safe and quality products, while being spurred by a group of dedicated individuals who are driven by an irrepressible zeal to work with a sense of team spirit towards a common goal.`,
              },
              {
                title: "Values",
                icon: LuGem,
                text: `Accountability, Quality and Safety, Innovation, Good Governance, Customer Satisfaction, Teamwork, Social and Environmental caring`,
              },
            ].map((card, i) => {
              const Icon = card.icon;
              return (
                <motion.div
                  key={card.title}
                  className="flex-1 bg-[#EEEEEE] p-10 rounded-[30px] text-center flex flex-col mt-10 md:mt-0"
                  variants={cardVariants}
                  initial="hidden"
                  whileInView="visible"
                  custom={i}
                  viewport={{ once: true, amount: 0.3 }}
                >
                  {/* ICON */}
                  <motion.div
                    className="flex justify-center -mt-20 mb-10"
                    initial={{ scale: 0.8, opacity: 0 }}
                    whileInView={{ scale: 1, opacity: 1 }}
                    transition={{ duration: 0.5, delay: i * 0.2 }}
                    viewport={{ once: true }}
                  >
                    <div className="bg-[#0c0c0c] rounded-full p-3 md:p-5 w-[80px] h-[80px] md:w-[100px] md:h-[100px] flex items-center justify-center">
                      <Icon className="text-white w-10 h-10 md:w-14 md:h-14" />
                    </div>
                  </motion.div>

                  {/* TITLE */}
                  <h4
                    className="font-semibold mb-3 font-philosopher"
                    style={{ fontSize: "36px" }}
                  >
                    {card.title}
                  </h4>

                  {/* CONTENT */}
                  {card.title === "Values" ? (
                    <ul
                      className="text-[#909090] text-[16px] mt-2 flex flex-col gap-1 text-center mx-auto font-cabin max-w-[280px]"
                      style={{ fontFamily: "cabin" }}
                    >
                      {card.text.split(",").map((value, idx) => (
                        <li key={idx} className="leading-relaxed">
                          • {value.trim()}
                        </li>
                      ))}
                    </ul>
                  ) : (
                    <p className="text-[#909090] text-sm mt-2 flex-grow font-cabin text-justify">
                      {card.text}
                    </p>
                  )}
                </motion.div>
              );
            })}
          </div>
        </div>
      </section>
    </>
  );
}
