import BlogSlider from "./BlogSlider";

interface Blog {
  title: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

async function getBlogs(): Promise<Blog[]> {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  try {
    const res = await fetch(`${BASE_URL}/api/v1/blogs/latest`, {
      cache: "no-store",
    });

    if (!res.ok) {
      console.error("Failed to fetch latest blogs", res.status);
      return [];
    }

    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching blogs:", error);
    return [];
  }
}

export default async function NewsSection() {
  const blogs = await getBlogs();

  if (!blogs || blogs.length === 0) {
    return null;
  }

  return (
    <section className="pb-[130px] bg-white">
      <div className="container mx-auto px-4 text-center">
        <span className="sub-header">News & Updates</span>
        <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mt-2 mb-15">
          Updates & Announcements
        </h2>

        <BlogSlider blogs={blogs} />
      </div>
    </section>
  );
}
