import HeroSlider from "./HeroSlider";

interface Slider {
  title: string;
  description: string;
  background_image_url: string;
  image_url: string;
}

async function getSlides(): Promise<Slider[]> {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  try {
    const res = await fetch(`${BASE_URL}/api/v1/sliders/active`, {
      cache: "no-store",
    });

    if (!res.ok) {
      console.error("Failed to fetch sliders", res.status);
      return [];
    }

    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching sliders:", error);
    return [];
  }
}

export default async function HeroSection() {
  const slides = await getSlides();

  return <HeroSlider slides={slides} />;
}
