"use client";

import { AnimatePresence, motion } from "framer-motion";
import Image from "next/image";
import Link from "next/link";
import { useEffect, useState } from "react";
import {
  FaFacebookF,
  FaLinkedinIn,
  FaYoutube,
  FaMapMarkerAlt,
  FaEnvelope,
  FaPhoneAlt,
  FaInstagram,
} from "react-icons/fa";

export default function Footer() {
  return (
    <footer className="bg-[#1F1E1E]">
      <div className="container mx-auto px-4 pt-20">
        {/* Top section: Logo + Contact Info + Socials */}
        <div className="grid grid-cols-1 gap-8 lg:grid-cols-3">
          <div className="flex flex-col items-center lg:items-start mb-10 lg:mb-0">
            {/* Logo */}
            <Link href="/" className="inline-block mb-4">
              <Image
                src="/images/logo.png"
                alt="Company Logo"
                width={140}
                height={76}
                className="object-contain"
              />
            </Link>

            {/* Contact Info with Icons */}
            <div className="flex flex-col items-center lg:items-start mb-5 text-white space-y-5 text-[16px] pt-5">
              <div className="flex items-center gap-5">
                <FaMapMarkerAlt />
                <Link
                  href="https://maps.app.goo.gl/yZiC1RYdjvwr42U59"
                  target="_blank"
                >
                  <span>
                    585, School Lane, Pelawatta,
                    <br />
                    Battaramulla, Sri Lanka
                  </span>
                </Link>
              </div>
              <div className="flex items-center gap-5">
                <FaEnvelope />
                <Link href="mailto:info@pussalla.com">
                  <span>info@pussalla.com</span>
                </Link>
              </div>
              <div className="flex items-center gap-5">
                <FaPhoneAlt />
                <div className="flex flex-row md:flex-col items-center justify-center gap-2">
                  <Link href="tel:0362255062">
                    <span>
                      036 2255 062
                      <br />
                      036 2255 062
                    </span>
                  </Link>
                </div>
              </div>
            </div>

            {/* Social Media */}
            <div className="lg:flex lg:gap-3 lg:text-lg hidden lg:justify-center lg:justify-start pt-5">
              {[
                {
                  icon: FaFacebookF,
                  href: "https://www.facebook.com/meatshop.pussalla/",
                },
                {
                  icon: FaLinkedinIn,
                  href: "https://lk.linkedin.com/company/pussallameatproducers",
                },
                {
                  icon: FaInstagram,
                  href: "https://www.instagram.com/meatshop.pussalla/?hl=en",
                },
                {
                  icon: FaYoutube,
                  href: "https://www.youtube.com/@pussallasausages7409",
                },
              ].map(({ icon: Icon, href }, i) => (
                <a
                  key={i}
                  href={href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 flex items-center justify-center rounded-full bg-white hover:bg-[#ac9242] transition"
                >
                  <Icon />
                </a>
              ))}
            </div>
          </div>

          {/* Links Section */}
          <div className="grid grid-cols-2 gap-8 md:grid-cols-3 lg:grid-cols-3 lg:col-span-2">
            <div>
              <p className="font-medium text-white">Company</p>
              <ul className="mt-4 space-y-2 text-[18px] text-white">
                <li>
                  <Link href="/about/story" className="hover:text-[#ac9242]">
                    Our Story
                  </Link>
                </li>
                <li>
                  <Link href="/about/commitee" className="hover:text-[#ac9242]">
                    Our Committee
                  </Link>
                </li>
                <li>
                  <Link href="/about/awards" className="hover:text-[#ac9242]">
                    Awards
                  </Link>
                </li>
                <li>
                  <Link href="/about/csr" className="hover:text-[#ac9242]">
                    CSR Projects
                  </Link>
                </li>
                <li>
                  <Link href="/sustainability" className="hover:text-[#ac9242]">
                    Sustainability
                  </Link>
                </li>
              </ul>
            </div>

            <div>
              <p className="font-medium text-white">Quick Links</p>
              <ul className="mt-4 space-y-2 text-[18px] text-white">
                <li>
                  <Link href="/contact" className="hover:text-[#ac9242]">
                    Contact Us
                  </Link>
                </li>
                <li>
                  <Link href="/careers" className="hover:text-[#ac9242]">
                    Careers
                  </Link>
                </li>
                <li>
                  <Link href="/blog" className="hover:text-[#ac9242]">
                    Our Blogs
                  </Link>
                </li>
                <li>
                  <Link href="/privacy-policy" className="hover:text-[#ac9242]">
                    Privacy Policy
                  </Link>
                </li>
                <li>
                  <Link
                    href="/terms-and-conditions"
                    className="hover:text-[#ac9242]"
                  >
                    Terms & Conditions
                  </Link>
                </li>
              </ul>
            </div>

            <div>
              <p className="font-medium text-white">Services</p>
              <ul className="mt-4 space-y-2 text-[18px] text-white">
                <li>
                  <Link
                    href="/services/poultry-breeding-hatcheries-1"
                    className="hover:text-[#ac9242]"
                  >
                    Poultry Breeding & Hatcheries
                  </Link>
                </li>
                <li>
                  <Link
                    href="/services/animal-feed-agricultural-support-1"
                    className="hover:text-[#ac9242]"
                  >
                    Animal Feed & Agricultural Support
                  </Link>
                </li>
                <li>
                  <Link
                    href="/services/fresh-and-value-added-meat-varieties"
                    className="hover:text-[#ac9242]"
                  >
                    Fresh and Value-added meat varieties
                  </Link>
                </li>
                <li>
                  <Link
                    href="/services/retail-distribution-1"
                    className="hover:text-[#ac9242]"
                  >
                    Retail & Distribution
                  </Link>
                </li>
                <li>
                  <Link
                    href="/services/exporting-1"
                    className="hover:text-[#ac9242]"
                  >
                    Exporting
                  </Link>
                </li>
              </ul>
            </div>
          </div>
        </div>

        {/* Bottom Section */}
        <div className="flex flex-col md:flex-row md:items-center md:justify-between mt-20 gap-4 border-t border-white py-3">
          <p className="text-white text-center">
            Copyright &copy; {new Date().getFullYear()} All rights reserved
          </p>
          <div className="flex flex-row gap-4 justify-center md:justify-start">
            <p className="text-white text-center">
              Developed by{" "}
              <a
                href="https://gallezone.com/"
                target="_blank"
                rel="noopener noreferrer"
                className="hover:text-[#ac9242]"
              >
                GalleZone
              </a>
            </p>
          </div>
        </div>
      </div>
      {/* Back to Top Button */}
      <BackToTopButton />
    </footer>
  );
}

// Back to Top Button Component
function BackToTopButton() {
  const [visible, setVisible] = useState(false);

  useEffect(() => {
    const toggleVisibility = () => {
      if (window.scrollY > 300) setVisible(true);
      else setVisible(false);
    };

    window.addEventListener("scroll", toggleVisibility);
    return () => window.removeEventListener("scroll", toggleVisibility);
  }, []);

  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth",
    });
  };

  return (
    <AnimatePresence>
      {visible && (
        <motion.button
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          exit={{ opacity: 0, y: 20 }}
          transition={{ duration: 0.3 }}
          onClick={scrollToTop}
          className="fixed bottom-6 right-6 z-[1000] bg-[#ac9242] text-white rounded-full p-3 shadow-lg hover:bg-[#947d35] transition-colors cursor-pointer"
          aria-label="Back to top"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            className="w-6 md:w-8 h-6 md:h-8"
            fill="none"
            viewBox="0 0 24 24"
            stroke="currentColor"
            strokeWidth={2}
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              d="M5 15l7-7 7 7"
            />
          </svg>
        </motion.button>
      )}
    </AnimatePresence>
  );
}
