"use client";

import { useState } from "react";

interface FAQProps {
  faqs: { question: string; answer: string }[];
}

export default function FAQ({ faqs }: FAQProps) {
  const [openIndex, setOpenIndex] = useState<number | null>(null);
  const toggleFAQ = (index: number) =>
    setOpenIndex(openIndex === index ? null : index);

  return (
    <div className="space-y-6">
      {faqs.map((faq, index) => (
        <div
          key={index}
          className="bg-[#EBEBEB] rounded-[15px] p-6 cursor-pointer"
        >
          <div
            className="flex justify-between items-center"
            onClick={() => toggleFAQ(index)}
          >
            <h4 className="text-lg font-semibold">{faq.question}</h4>
            <span style={{ fontSize: "40px" }}>
              {openIndex === index ? "−" : "+"}
            </span>
          </div>
          <div
            className={`overflow-hidden transition-all duration-500 ease-in-out ${
              openIndex === index ? "max-h-40 mt-3" : "max-h-0"
            }`}
          >
            <p className="text-[#909090]">{faq.answer}</p>
          </div>
        </div>
      ))}
    </div>
  );
}
