"use client";

import Image from "next/image";

type CommiteeCardProps = {
  img: string;
  designation: string;
  name: string;
};

export default function CommiteeCard({
  img,
  designation,
  name,
}: CommiteeCardProps) {
  return (
    <div className="flex-1 bg-[#EEEEEE] p-6 sm:p-8 md:p-10 rounded-[20px] sm:rounded-[25px] lg:rounded-[30px] text-center flex flex-col items-center transition-all duration-300 mb-20">
      {/* Image */}
      <div className="flex justify-center -mt-25 sm:-mt-20 md:-mt-25 mb-4 sm:mb-5">
        <Image
          src={img}
          alt={name}
          width={150}
          height={150}
          className="rounded-full object-cover w-[150px] h-[150px]"
        />
      </div>

      {/* Name */}
      <h4 className="text-base sm:text-lg md:text-xl font-semibold leading-snug">
        {name}
      </h4>

      {/* Designation */}
      <p className="text-[#909090] text-sm sm:text-base mt-2 flex-grow max-w-xs">
        {designation}
      </p>
    </div>
  );
}
