import Clients from "./Clients";

export default async function ClientsSection() {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL!;
  let partners = [];

  try {
    const res = await fetch(`${BASE_URL}/api/v1/partners/active`, {
      cache: "no-store", // optional: always fetch latest
    });
    if (res.ok) {
      const json = await res.json();
      partners = json.data || [];
    }
  } catch (error) {
    console.error("Error fetching partners:", error);
  }

  return (
    <section className="py-[130px] bg-white">
      <div className="container mx-auto px-4 text-center">
        <span className="sub-header">Clients</span>
        <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mt-2 mb-15">
          Our Partners
        </h2>
        <Clients partners={partners} />
      </div>
    </section>
  );
}
