"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, FreeMode } from "swiper/modules";
import Image from "next/image";
import "swiper/css";

interface Partner {
  name: string;
  logo_url: string;
}

export default function Clients({ partners }: { partners: Partner[] }) {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  if (!partners || partners.length === 0) {
    return <p className="text-center py-0"></p>;
  }

  const getLogoUrl = (url: string) => {
    if (!url) return "";
    return url.startsWith("http") ? url : `${BASE_URL}${url}`;
  };

  return (
    <div className="w-full">
      <Swiper
        modules={[Autoplay, FreeMode]}
        speed={3000} // smooth scrolling speed
        autoplay={{
          delay: 1, // must be >0 to allow pause on hover
          disableOnInteraction: false,
          pauseOnMouseEnter: true, // pauses when hovered
        }}
        freeMode={{
          enabled: true,
          momentum: false,
        }}
        grabCursor={false}
        allowTouchMove={false}
        slidesPerView="auto"
        loop={true} // continuous loop
        breakpoints={{
          320: { spaceBetween: 40 },
          640: { spaceBetween: 60 },
          1024: { spaceBetween: 100 },
        }}
        className="w-full"
      >
        {partners.concat(partners).map((partner, i) => (
          <SwiperSlide key={i} style={{ width: "auto" }}>
            <div className="flex items-center justify-center h-16 sm:h-20 md:h-24 lg:h-28 xl:h-32">
              <Image
                src={getLogoUrl(partner.logo_url)}
                alt={partner.name || `Partner ${i + 1}`}
                width={150}
                height={100}
                className="object-contain w-auto max-h-10 sm:max-h-12 md:max-h-16 lg:max-h-20 transition-transform duration-300 hover:scale-105"
              />
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}
