"use client";

interface CareerCardProps {
  subtitle?: string;
  jobTitle: string;
  jobDescription?: string;
  jobLocation: string;
  jobType: string;
  jobClosingDate: string;
  buttonText?: string;
  buttonLink?: string;
}

export default function CareerCard({
  subtitle = "Open Roles",
  jobTitle,
  jobLocation,
  jobType,
  jobClosingDate,
  buttonText = "Apply Now",
  buttonLink = "#",
}: CareerCardProps) {
  return (
    <div className="bg-white border-b border-gray-200 py-10 md:py-15">
      <div className="flex flex-col md:flex-row items-center md:items-center justify-center mb-3 gap-5">
        <div className="flex-1 text-center md:text-left">
          <span
            className="text-sm text-[#E9202A] uppercase mb-2 block"
            style={{ padding: "0px" }}
          >
            {subtitle}
          </span>
          <h3
            className="text-xl font-bold text-gray-900"
            style={{ fontFamily: "Philosopher" }}
          >
            {jobTitle}
          </h3>
          <div className="flex flex-wrap gap-10 mt-2 md:mt-5">
            <div className="flex items-center gap-5 text-gray-500">
              <span className="w-2 h-2 rounded-full bg-[#D9D9D9] inline-block" />
              <span className="text-[#909090]" style={{ padding: "0px" }}>
                {jobLocation}
              </span>
              <span className="w-2 h-2 rounded-full bg-[#D9D9D9] inline-block" />
              <span className="text-[#909090]" style={{ padding: "0px" }}>
                {jobType}
              </span>
              <span className="w-2 h-2 rounded-full bg-[#D9D9D9] inline-block" />
              <span className="text-[#909090]" style={{ padding: "0px" }}>
                {jobClosingDate}
              </span>
            </div>
          </div>
        </div>
        <div className="flex-1 text-center md:text-right">
          <a href={buttonLink} className="primary-btn">
            {buttonText}
          </a>
        </div>
      </div>
    </div>
  );
}
