"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import CSRCard from "@/components/CSRCard";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

interface CSR {
  title: string;
  category: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

interface CSRSliderProps {
  projects: CSR[];
}

export default function CSRSlider({ projects }: CSRSliderProps) {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  const getImageUrl = (url: string) =>
    url.startsWith("http") ? url : `${BASE_URL}${url}`;

  return (
    <Swiper
      modules={[Navigation, Pagination, Autoplay]}
      navigation
      loop
      autoplay={{ delay: 3000, disableOnInteraction: false }}
      spaceBetween={15}
      slidesPerView={1}
      breakpoints={{
        480: { slidesPerView: 1, spaceBetween: 15 },
        640: { slidesPerView: 1, spaceBetween: 20 },
        768: { slidesPerView: 2, spaceBetween: 25 },
        1024: { slidesPerView: 2, spaceBetween: 30 },
      }}
      className="w-full"
    >
      {projects.map((project, i) => (
        <SwiperSlide key={i} className="flex justify-center">
          <CSRCard
            img={getImageUrl(project.featured_image_url)}
            title={project.title}
            description={project.description}
            date={project.created_at}
            slug={project.slug}
          />
        </SwiperSlide>
      ))}
    </Swiper>
  );
}
