"use client";

import Link from "next/link";
import CSRSlider from "@/components/CSRSlider";
import { motion } from "framer-motion";

interface CSR {
  title: string;
  category: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

interface CSRSectionProps {
  csrProjects: CSR[];
}

export default function CSRSection({ csrProjects }: CSRSectionProps) {
  if (!csrProjects || csrProjects.length === 0) return null;

  return (
    <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-white overflow-hidden">
      <div className="container mx-auto px-4">
        <div className="flex flex-col lg:flex-row items-start lg:items-center gap-10 lg:gap-16">
          {/* Left Content */}
          <motion.div
            className="flex-1 text-center lg:text-left"
            initial={{ opacity: 0, x: -80 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
            viewport={{ once: true, amount: 0.3 }}
          >
            <span className="sub-header">CSR PROJECTS</span>
            <h2 className="text-3xl sm:text-5xl lg:text-6xl xl:text-7xl font-bold mb-2 lg:mb-5 font-philosopher leading-tight">
              Preserved Ecologies, Empowered Communities
            </h2>
            <p className="text-[#909090] leading-relaxed font-cabin mb-8 sm:mb-10 lg:mb-12 text-sm sm:text-base md:text-lg">
              Our purpose goes beyond business success, towards the betterment
              of people, animals, and the planet. Through sustainable farming,
              responsible sourcing, and meaningful CSR efforts, we strive to
              create shared value for our employees, communities, and the
              environment while driving responsible growth.
            </p>
            <div className="flex justify-center lg:justify-start">
              <Link href="/about/csr" className="primary-btn whitespace-nowrap">
                Learn More
              </Link>
            </div>
          </motion.div>

          {/* Right Slider */}
          <motion.div
            className="flex-1 overflow-hidden w-full mt-0 lg:mt-0"
            initial={{ opacity: 0, x: 80 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, ease: "easeOut", delay: 0.2 }}
            viewport={{ once: true, amount: 0.3 }}
          >
            <CSRSlider projects={csrProjects} />
          </motion.div>
        </div>
      </div>
    </section>
  );
}
