"use client";

import { useState } from "react";
import CSRCard from "@/components/CSRCard";

interface CSRProject {
  title: string;
  category: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

export default function CSRFilter({
  csrList,
  categories,
}: {
  csrList: CSRProject[];
  categories: string[];
}) {
  const [activeCategory, setActiveCategory] = useState<string>("All");

  const filteredProjects =
    activeCategory === "All"
      ? csrList
      : csrList.filter((p) => p.category === activeCategory);

  return (
    <div>
      {/* Filter Buttons */}
      <div className="flex flex-wrap gap-5 justify-center mb-15">
        <button
          onClick={() => setActiveCategory("All")}
          className={`px-6 py-2 rounded-full text-lg font-medium transition ${
            activeCategory === "All"
              ? "bg-[#0c0c0c] text-white"
              : "bg-[#EEEEEE] text-gray-700 hover:bg-gray-200"
          }`}
          style={{ fontFamily: "Cabin" }}
        >
          All
        </button>
        {categories.map((cat) => (
          <button
            key={cat}
            onClick={() => setActiveCategory(cat)}
            className={`px-6 py-2 rounded-full text-lg font-medium transition ${
              activeCategory === cat
                ? "bg-[#0c0c0c] text-white"
                : "bg-[#EEEEEE] text-gray-700 hover:bg-gray-200"
            }`}
            style={{ fontFamily: "Cabin" }}
          >
            {cat}
          </button>
        ))}
      </div>

      {/* Projects Grid */}
      <div className="grid gap-6 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-4">
        {filteredProjects.map((project, index) => (
          <CSRCard
            key={index}
            slug={project.slug}
            img={project.featured_image_url}
            title={project.title}
            description={project.description}
            date={new Date(project.created_at).toLocaleDateString()}
          />
        ))}
      </div>
    </div>
  );
}
