"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import BlogCard from "@/components/BlogCard";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

interface Blog {
  title: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

interface BlogSliderProps {
  blogs: Blog[];
}

export default function BlogSlider({ blogs }: BlogSliderProps) {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  // Get proper image URL
  const getImageUrl = (url: string) =>
    url.startsWith("http") ? url : `${BASE_URL}${url}`;

  // Strip HTML tags from description
  const stripHTML = (html: string) => html.replace(/<[^>]+>/g, "");

  return (
    <Swiper
      modules={[Navigation, Pagination, Autoplay]}
      navigation
      loop
      autoplay={{ delay: 3000, disableOnInteraction: false }}
      spaceBetween={20}
      slidesPerView={1}
      breakpoints={{
        640: { slidesPerView: 1 },
        768: { slidesPerView: 2 },
        1024: { slidesPerView: 3 },
      }}
    >
      {blogs.map((blog, i) => (
        <SwiperSlide key={i}>
          <BlogCard
            img={getImageUrl(blog.featured_image_url)}
            date={blog.created_at}
            title={blog.title}
            description={
              blog.description.length > 150
                ? stripHTML(blog.description).slice(0, 150) + "..."
                : stripHTML(blog.description)
            }
            href={`/blog/${blog.slug}`}
          />
        </SwiperSlide>
      ))}
    </Swiper>
  );
}
