"use client";

import BlogSlider from "@/components/BlogSlider";
import { motion } from "framer-motion";

interface Blog {
  title: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

interface BlogSectionProps {
  blogs: Blog[];
}

export default function BlogSection({ blogs }: BlogSectionProps) {
  if (!blogs || blogs.length === 0) return null;

  return (
    <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-white">
      <div className="container mx-auto px-4 text-center">
        {/* Sub-header */}
        <motion.span
          className="sub-header block"
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.6, ease: "easeOut" }}
          viewport={{ once: true, amount: 0.3 }}
        >
          News & Updates
        </motion.span>

        {/* Title */}
        <motion.h2
          className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mb-10 lg:mb-15 font-philosopher"
          initial={{ opacity: 0, y: 50 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.8, ease: "easeOut", delay: 0.1 }}
          viewport={{ once: true, amount: 0.3 }}
        >
          Updates & Announcements
        </motion.h2>

        {/* Blog Slider */}
        <motion.div
          initial={{ opacity: 0, y: 80 }}
          whileInView={{ opacity: 1, y: 0 }}
          transition={{ duration: 0.9, ease: "easeOut", delay: 0.2 }}
          viewport={{ once: true, amount: 0.3 }}
        >
          <BlogSlider blogs={blogs} />
        </motion.div>
      </div>
    </section>
  );
}
