"use client";

import Image from "next/image";

type BenefitCardProps = {
  img: string;
  title: string;
  description: string;
};

export default function BenefitCard({
  img,
  title,
  description,
}: BenefitCardProps) {
  return (
    <div className="flex-1 bg-[#EEEEEE] p-10 rounded-[30px] text-center flex flex-col mt-10">
      <div className="flex justify-center -mt-20 mb-10">
        <Image
          src={img}
          alt={title}
          width={100}
          height={100}
          className="bg-[#0c0c0c] rounded-full p-5"
        />
      </div>
      <h4 className="text-lg font-semibold mb-2">{title}</h4>
      <p className="text-[#909090] text-sm mt-2 flex-grow">{description}</p>
    </div>
  );
}
