"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import Image from "next/image";

import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

interface Award {
  title: string;
  year: string;
  image_url: string;
}

interface Props {
  awards: Award[];
  baseUrl: string;
}

export default function AwardSlider({ awards, baseUrl }: Props) {
  const getImageUrl = (url: string) =>
    url.startsWith("http") ? url : `${baseUrl}${url}`;

  if (!awards || awards.length === 0) return null;

  return (
    <Swiper
      modules={[Navigation, Pagination, Autoplay]}
      loop={true}
      autoplay={{ delay: 3000, disableOnInteraction: false }}
      spaceBetween={20} // smaller spacing for mobile
      slidesPerView={2}
      breakpoints={{
        640: { slidesPerView: 2, spaceBetween: 20 },
        768: { slidesPerView: 3, spaceBetween: 25 },
        1024: { slidesPerView: 3, spaceBetween: 30 },
        1280: { slidesPerView: 4, spaceBetween: 30 },
      }}
      className="w-full"
    >
      {awards.map((award, i) => (
        <SwiperSlide key={i} className="flex justify-center">
          <div className="flex flex-col items-center gap-2 max-w-[200px] w-full">
            <Image
              src={getImageUrl(award.image_url)}
              alt={award.title}
              width={150}
              height={150}
              className="h-[120px] sm:h-[130px] md:h-[150px] object-contain"
            />
            <p className="text-gray-700 font-medium text-center text-sm sm:text-base">
              {award.title} {award.year}
            </p>
          </div>
        </SwiperSlide>
      ))}
    </Swiper>
  );
}
