"use client";

import Image from "next/image";

type AwardCardProps = {
  img: string;
  title: string;
  year?: string;
  awardingBody?: string;
};

export default function AwardCard({
  img,
  title,
  year,
  awardingBody,
}: AwardCardProps) {
  return (
    <div className="bg-[#EEEEEE] rounded-[30px] p-10 flex flex-col items-center gap-2 w-full text-center h-full">
      <Image
        src={img}
        alt={title}
        className="max-h-[200px] object-contain"
        width={300}
        height={300}
      />
      <h4 className="text-gray-700 font-medium text-center mt-5">
        {title} {year}
      </h4>
      {awardingBody && <p className="text-gray-500 text-sm">{awardingBody}</p>}
    </div>
  );
}
