"use client";

import { motion } from "framer-motion";
import Image from "next/image";
import Link from "next/link";

export default function AboutSection() {
  return (
    <motion.section
      className="py-[80px] sm:py-[100px] lg:py-[130px] bg-white overflow-hidden"
      id="about"
      initial={{ opacity: 0, y: 60 }}
      whileInView={{ opacity: 1, y: 0 }}
      transition={{ duration: 0.8, ease: "easeOut" }}
      viewport={{ once: true, amount: 0.2 }} // only animates once when 20% in view
    >
      <div className="container px-4 mx-auto">
        <div className="flex flex-col lg:flex-row items-center gap-10 lg:gap-16">
          {/* Left Image */}
          <motion.div
            className="relative flex-1 w-full h-full"
            initial={{ opacity: 0, x: -60 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, delay: 0.2 }}
            viewport={{ once: true }}
          >
            <Image
              src="/images/about/about-us.webp"
              alt="About Us"
              width={600}
              height={400}
              className="rounded-[20px] md:rounded-[30px] object-cover w-full h-full"
            />

            {/* Overlay */}
            {/* <div className="absolute inset-0 rounded-[20px] md:rounded-[30px] bg-gradient-to-t from-black/80 via-black/40 to-transparent"></div> */}

            {/* Badge */}
            <div className="absolute bg-black/70 border bottom-5 left-5 right-0 lg:bottom-9 lg:left-9 lg:right-0 w-fit px-4 py-4 lg:px-8 lg:py-8 rounded-[10px] md:rounded-[20px] lg:rounded-[25px] text-white gap-6">
              <div className="flex flex-col items-center">
                <h1 className="text-7xl font-bold font-philosopher">30+</h1>
                <p className="text-sm text-white font-cabin">
                  Years of Excellence
                </p>
              </div>
            </div>
          </motion.div>

          {/* Right Text */}
          <motion.div
            className="flex-1 text-center lg:text-left"
            initial={{ opacity: 0, x: 60 }}
            whileInView={{ opacity: 1, x: 0 }}
            transition={{ duration: 0.8, delay: 0.4 }}
            viewport={{ once: true }}
          >
            <span className="sub-header">About Us</span>
            <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold font-philosopher mb-2 lg:mb-5">
              The Legacy of Trust from Farm-to Fork
            </h2>
            <h4 className="text-xl sm:text-2xl lg:text-2xl font-bold font-cabin mt-2 mb-5 lg:mt-3 lg:mb-2">
              From a Family Farm to a Fully Integrated Agri-Business
            </h4>
            <p className="text-[#707070] leading-relaxed font-cabin mb-8 lg:mb-12">
              Pussalla Meat Producers (Pvt) Ltd began its journey as a small
              broiler chicken farm in 1988, evolving into Sri Lanka’s most
              trusted and fully integrated brand in poultry. Today, our business
              model encompasses the entire value-chain; from breeding and
              processing to distributing and retailing, ensuring total
              self-sufficiency, uncompromising quality, and traceability. As a
              result, we have continually delivered excellence from
              Farm-to-Fork, helping us to uphold a legacy of trust across all
              our stakeholders.
            </p>
            <Link href="/about/story" className="primary-btn inline-block">
              Explore More
            </Link>
          </motion.div>
        </div>
      </div>
    </motion.section>
  );
}
