"use client";

import Image from "next/image";
import Banner from "@/components/Banner";
import { motion } from "framer-motion";

export const dynamic = "force-dynamic";

export default function CommiteePage() {
  return (
    <>
      <Banner
        title="Sustainability"
        breadcrumbs={[
          { label: "Home", href: "/" },
          { label: "Sustainability" },
        ]}
      />

      {/* Sustainability Sections */}
      {[
        {
          title: "Environmental Preservation",
          text: `Pussalla strongly believes in growing with utmost respect for
          the environment, as ultimately we are all a part of it. In every
          part of our operation, we give considerable care to evaluate the
          impact on the environment and the steps that should be taken to
          minimise the impact. This is an example that we have set across
          the whole industry, encouraging other businesses grow with
          respect to the environment. As a result, all our key sites have
          been accredited with the ISO 14001 certification, which is the
          internationally recognised standard for environmental
          management.`,
          imgSrc: "/images/sustainabilities/environmental-presevation.webp",
          reverse: false,
        },
        {
          title: "Waste Management",
          text: `Nothing should end up as waste, and anything that does should
          end up in something useful. Driven by this doctrine, Pussalla
          emphasises the 3R Principle of Reduce, Reuse, and Recycle, to
          minimize waste and convert it into new value-added products. The
          bio waste from our farms, hatcheries, and meat processing
          facilities is recycled to produce high-nutrient animal feed,
          while broiler litter and sludge are converted into organic
          fertilisers. These value-added products cater to the needs of
          our own farming products as well as other farms and growers in
          Sri Lanka.`,
          imgSrc: "/images/sustainabilities/waste-management.webp",
          reverse: true,
        },
        {
          title: "Responsible Energy Consumption",
          text: `We continually strive to enhance our sustainability in energy
          consumption. Currently, almost 50% of the energy for farms,
          hatcheries, and processing plants is supplied via six solar
          installations located in Kurunegala, Puttalam, and Dompe
          regions. Additionally, our plants and office buildings are
          installed with energy-efficient lighting and machinery, cutting
          down excessive energy use in every way possible. These efforts
          not only reduce our carbon footprint, but uphold our promise of
          being a responsible business.`,
          imgSrc: "/images/sustainabilities/responsible-energy.webp",
          reverse: false,
        },
        {
          title: "Ethical Farming and Animal Welfare",
          text: `Caring for animals is both a moral duty and the foundation of
          the uncompromised quality and hygiene of our produce. From
          hatcheries to farms and processing, every stage of our
          operations is guided by utmost compassion and care.
          Our approach to animal welfare begins with spacious, clean, and
          well-ventilated housing, allowing birds to move freely and
          exhibit their natural behaviours. Each bird has continuous
          access to clean water and a nutritious, balanced diet, free from
          growth promoters. These birds are handled gently by trained
          professional staff, including regular health checks performed by
          veterinary teams. Regular audits and global-standard assessments
          help us continuously improve, reaffirming our deep commitment to
          animal welfare and responsible food production.`,
          imgSrc: "/images/sustainabilities/ethical-farming.webp",
          reverse: true,
        },
        {
          title: "Community Development",
          text: `Ultimately, the responsibility of our business extends to the
          voices of the broader Sri Lankan community. To satisfy their
          diverse needs and expectations, we speak to their hearts through
          a variety of ways, such as training and development
          opportunities, research and knowledge-sharing, as well as
          development projects. Our school development initiatives support
          local schools through scholarships and infrastructure assistance,
          nurturing future leaders in agriculture. Through community
          education and farmer empowerment programs, we also help rural
          farmers adopt best practices in poultry management, crop
          cultivation, and sustainable farming, improving both their
          productivity and livelihoods.`,
          imgSrc: "/images/sustainabilities/community-development.webp",
          reverse: false,
        },
      ].map((section, index) => (
        <motion.section
          key={index}
          className={`${
            index === 0
              ? "py-[80px] sm:py-[100px] lg:py-[130px]"
              : "pb-[80px] sm:pb-[100px] lg:pb-[130px]"
          } bg-white`}
          initial="hidden"
          whileInView="visible"
          viewport={{ once: true, amount: 0.3 }}
        >
          <div className="container px-4 mx-auto">
            <div
              className={`flex flex-col lg:flex-row items-center gap-10 lg:gap-16 ${
                section.reverse ? "lg:flex-row-reverse" : ""
              }`}
            >
              {/* Image */}
              <motion.div
                className="relative flex-1 w-full"
                variants={{
                  hidden: { opacity: 0, x: section.reverse ? 50 : -50 },
                  visible: { opacity: 1, x: 0, transition: { duration: 0.8 } },
                }}
              >
                <Image
                  src={section.imgSrc}
                  alt={section.title}
                  width={600}
                  height={400}
                  className="rounded-[20px] md:rounded-[30px] object-cover w-full h-[400px] lg:h-full"
                />
              </motion.div>

              {/* Text */}
              <motion.div
                className="flex-1 text-center lg:text-left"
                variants={{
                  hidden: { opacity: 0, x: section.reverse ? -50 : 50 },
                  visible: { opacity: 1, x: 0, transition: { duration: 0.8 } },
                }}
              >
                <h2 className="text-3xl sm:text-4xl md:text-6xl xl:text-6xl font-bold font-philosopher mb-5">
                  {section.title}
                </h2>
                <p className="text-[#909090] text-base sm:text-lg leading-relaxed font-cabin">
                  {section.text}
                </p>
              </motion.div>
            </div>
          </div>
        </motion.section>
      ))}
    </>
  );
}
