import HeroSlider from "@/components/HeroSlider";
import ServicesSection from "@/components/ServicesSection";
import Clients from "@/components/Clients";
import AboutSection from "@/components/AboutSection";
import WhyUsSection from "@/components/WhyUsSection";
import type { Metadata } from "next";
import SustainabilitySection from "@/components/SustainabilitySection";
import AwardsSection from "@/components/AwardsSection";
// import CSRSection from "@/components/CSRSection";
import BlogSection from "@/components/BlogSection";

export const dynamic = "force-dynamic";

interface Slider {
  title: string;
  description: string;
  background_image_url: string;
  image_url: string;
}

interface Partner {
  name: string;
  logo_url: string;
}

interface Award {
  title: string;
  description: string;
  year: string;
  image_url: string;
}

// interface CSR {
//   title: string;
//   category: string;
//   description: string;
//   slug: string;
//   created_at: string;
//   featured_image_url: string;
// }

interface Blog {
  title: string;
  description: string;
  slug: string;
  created_at: string;
  featured_image_url: string;
}

const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

async function getSlides(): Promise<Slider[]> {
  try {
    const res = await fetch(`${BASE_URL}/api/v1/sliders/active`, {
      cache: "no-store",
    });
    if (!res.ok) return [];
    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching sliders:", error);
    return [];
  }
}

async function getPartners(): Promise<Partner[]> {
  try {
    const res = await fetch(`${BASE_URL}/api/v1/partners/active`, {
      cache: "no-store",
    });
    if (!res.ok) return [];
    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching partners:", error);
    return [];
  }
}

async function getAwards(): Promise<Award[]> {
  try {
    const res = await fetch(`${BASE_URL}/api/v1/awards/latest`, {
      cache: "no-store",
    });
    if (!res.ok) return [];
    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching awards:", error);
    return [];
  }
}

// async function getCSRProjects(): Promise<CSR[]> {
//   try {
//     const res = await fetch(`${BASE_URL}/api/v1/csr/latest`, {
//       cache: "no-store",
//     });
//     if (!res.ok) return [];
//     const json = await res.json();
//     return json.data || [];
//   } catch (error) {
//     console.error("Error fetching CSR projects:", error);
//     return [];
//   }
// }

async function getBlogs(): Promise<Blog[]> {
  try {
    const res = await fetch(`${BASE_URL}/api/v1/blogs/latest`, {
      cache: "no-store",
    });
    if (!res.ok) return [];
    const json = await res.json();
    return json.data || [];
  } catch (error) {
    console.error("Error fetching blogs:", error);
    return [];
  }
}

export const metadata: Metadata = {
  title: "Pussalla Meat Sri Lanka | Meat and Poultry based Products",
  description:
    "Pussalla Meat is Sri Lanka’s sole fully integrated poultry supplier of fresh and value-added meat along with Poultry Breeding and Genetics.",
  keywords: [
    "pussella meat",
    "pussella meat shop",
    "pussalla meat shop",
    "pussella meat shop head office",
    "pussella meat online",
    "meat suppliers sri lanka",
    "restaurant meat suppliers sri lanka",
    "chicken suppliers sri lanka",
    "processed meat sri lanka",
    "processed meat suppliers sri lanka",
    "processed meat producers sri lanka",
    "value-added meat",
    "meat exporter",
    "poultry supplier",
    "poultry breeding farms in sri lanka",
    "hatchery eggs",
    "poultry breeding companies",
    "poultry breeding and genetics",
    "one-day chicks suppliers",
    "grand parent farm",
  ],
  openGraph: {
    title: "Pussalla Meat Sri Lanka | Meat and Poultry based Products",
    description:
      "Sri Lanka’s sole fully integrated poultry supplier of fresh and value-added meat products.",
    url: "https://pussalla-frontend.vercel.app",
    siteName: "Pussalla Meat",
    type: "website",
  },
};

export default async function Home() {
  const slides = await getSlides();
  const partners = await getPartners();
  const awards = await getAwards();
  // const csrProjects = await getCSRProjects();
  const blogs = await getBlogs();

  return (
    <>
      {/* Hero Section */}
      <HeroSlider slides={slides} />

      {/* About Section */}
      <AboutSection />

      {/* Services Section */}
      <ServicesSection />

      {/* Why Us Section */}
      <WhyUsSection />

      {/* Clients Section */}
      <section className="py-[100px] lg:py-[130px] bg-white">
        <div className="container mx-auto px-4 text-center">
          <span className="sub-header">Clients</span>
          <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mb-15">
            Our Partners
          </h2>
          <Clients partners={partners} />
        </div>
      </section>

      {/* Awards Section */}
      <AwardsSection awards={awards} baseUrl={BASE_URL!} />

      {/* CSR Section */}
      {/* <CSRSection csrProjects={csrProjects} /> */}

      {/* Sustainability Section */}
      <SustainabilitySection />

      {/* News Section */}
      <BlogSection blogs={blogs} />
    </>
  );
}
