// src/app/not-found.tsx
import Link from "next/link";

export default function NotFound() {
  return (
    <div className="min-h-screen flex flex-col items-center justify-center px-6 py-20 text-center bg-white">
      {/* Big 404 */}
      <h1 className="text-[100px] sm:text-[140px] lg:text-[180px] font-bold text-[#AD9343] leading-none">
        404
      </h1>

      {/* Title */}
      <h3 className="text-xl sm:text-2xl lg:text-3xl font-semibold mt-4">
        Page Not Found
      </h3>

      {/* Subtitle */}
      <p className="text-gray-600 mt-3 max-w-xl">
        Sorry, the page you are looking for doesn’t exist or has been removed.
      </p>

      {/* Button */}
      <Link
        href="/"
        className="primary-btn mt-8 px-8 py-3 text-base sm:text-lg"
      >
        Back to Home
      </Link>
    </div>
  );
}
