import Banner from "@/components/Banner";
import CareerCard from "@/components/CareerCard";
import Link from "next/link";

export const dynamic = "force-dynamic";

const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

interface Career {
  job_title: string;
  location: string;
  employment_type: string;
  closing_date: string;
  slug: string;
}

export default async function Careers() {
  // Fetch active vacancies from API
  const res = await fetch(`${BASE_URL}/api/v1/careers/active`, {
    cache: "no-store",
  });

  if (!res.ok) {
    throw new Error("Failed to fetch careers");
  }

  const json = await res.json();
  const careers: Career[] = json.data;

  return (
    <>
      <Banner
        title="Careers"
        breadcrumbs={[{ label: "Home", href: "/" }, { label: "Careers" }]}
      />

      {/* Careers Section */}
      <section className="py-[80px] sm:py-[100px] lg:py-[130px] bg-white">
        <div className="container mx-auto px-4">
          {/* Header Row */}
          <div
            className="
        flex flex-col 
        md:flex-row 
        md:items-center 
        md:justify-between 
        gap-6 
        border-b border-gray-200 
        pb-10 sm:pb-12 lg:pb-15
      "
          >
            <div className="text-center md:text-left">
              <span className="sub-header">Careers</span>
              <h2 className="text-3xl sm:text-5xl lg:text-7xl xl:text-6xl font-bold mt-1 md:mt-2">
                Our Open Roles
              </h2>
            </div>

            {/* Email Contact */}
            <div className="text-center md:text-right">
              <span className="text-[#909090] text-base sm:text-lg font-semibold uppercase block">
                Or contact with us
              </span>
              <h4 className="font-semibold text-lg sm:text-xl">
                <a href="mailto:hr@pussalla.com">hr@pussalla.com</a>
              </h4>
            </div>
          </div>

          {/* Career Cards */}
          <div className="mt-8 sm:mt-10">
            {careers.length > 0 ? (
              careers.map((career, idx) => (
                <CareerCard
                  key={idx}
                  jobTitle={career.job_title}
                  jobDescription=""
                  jobLocation={career.location}
                  jobType={career.employment_type}
                  jobClosingDate={career.closing_date}
                  buttonLink={`/careers/${career.slug}`}
                />
              ))
            ) : (
              <div className="text-center">
                <p className="text-center py-5 md:py-10 text-gray-500">
                  No vacancies available.
                </p>
                <Link href="/contact" className="primary-btn inline-block">
                  Contact Us
                </Link>
              </div>
            )}
          </div>
        </div>
      </section>
    </>
  );
}
