import Banner from "@/components/Banner";
import Clients from "@/components/Clients";
import Milestones from "@/components/Milestones";
import OverviewSection from "@/components/OverviewSection";
import Image from "next/image";

export const dynamic = "force-dynamic"; // <- ADD THIS HERE

type Milestone = {
  year: string;
  title: string;
  description: string;
  image_url: string;
};

type Partner = {
  name: string;
  logo_url: string;
};

async function getMilestones() {
  const res = await fetch(
    `${process.env.NEXT_PUBLIC_BASE_URL}/api/v1/milestones/active`,
    { cache: "no-store" }
  );
  if (!res.ok) throw new Error("Failed to fetch milestones");
  const json = await res.json();
  return json.data as Milestone[];
}

async function getPartners() {
  const res = await fetch(
    `${process.env.NEXT_PUBLIC_BASE_URL}/api/v1/partners/active`,
    { cache: "no-store" }
  );
  if (!res.ok) throw new Error("Failed to fetch partners");
  const json = await res.json();
  return json.data as Partner[];
}

export default async function AboutPage() {
  const milestones = await getMilestones();
  const partners = await getPartners();

  return (
    <>
      <Banner
        title="Our Story"
        breadcrumbs={[
          { label: "Home", href: "/" },
          { label: "About" },
          { label: "Our Story" },
        ]}
      />

      {/* Overview */}
      <OverviewSection />

      {/* Milestones */}
      <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-white">
        <div className="container mx-auto px-4">
          <Milestones milestones={milestones} />
        </div>
      </section>

      {/* Clients */}
      <section className="py-[80px] sm:py-[100px] lg:py-[130px] rounded-t-[50px] md:rounded-t-[100px] bg-linear-to-t from-[#FFFFFF] to-[#EEEEEE]">
        <div className="container mx-auto px-4 text-center">
          <span className="sub-header">Clients</span>
          <h2 className="text-4xl sm:text-6xl lg:text-7xl xl:text-6xl font-bold mb-10 md:mb-15">
            Our Partners
          </h2>
          <Clients partners={partners} />
        </div>
      </section>

      {/* Company */}
      <section className="pb-[80px] sm:pb-[100px] lg:pb-[130px] bg-white hidden">
        <div className="container mx-auto px-4">
          <div className="flex flex-col md:flex-row items-center gap-10 lg:gap-16">
            {/* Image Section */}
            <div className="relative flex-1 w-full">
              <Image
                src="/images/about/about-02.png"
                alt="About Us"
                width={600}
                height={400}
                className="rounded-[30px] object-cover w-full"
              />
            </div>

            {/* Text Section */}
            <div className="flex-1 text-center md:text-left px-2 sm:px-4 md:px-0">
              <span className="sub-header block">Company</span>

              <h2 className="text-3xl sm:text-5xl lg:text-7xl xl:text-6xl font-bold font-philosopher mb-4 leading-tight">
                Defining Our Identity
              </h2>

              <h4 className="text-xl sm:text-2xl font-bold font-cabin mt-3 mb-2 leading-snug">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit
              </h4>

              <p className="text-[#909090] font-cabin leading-relaxed text-sm sm:text-base md:text-lg max-w-2xl mx-auto md:mx-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                eiusmod tempor incididunt ut labore et dolore magna aliqua.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                eiusmod tempor incididunt ut labore et dolore magna aliqua.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                eiusmod tempor incididunt ut labore et dolore magna aliqua.
              </p>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
