// server.js

const { createServer } = require("http");
const next = require("next");

// cPanel Node.js app PORT is provided automatically
const port = process.env.PORT || 3000;

// Production mode
const dev = false;
const app = next({ dev });
const handle = app.getRequestHandler();

app.prepare().then(() => {
  createServer((req, res) => {
    handle(req, res);
  }).listen(port, (err) => {
    if (err) throw err;
    console.log(`Next.js app running on port ${port}`);
  });
});
